<?php
namespace BooklyPro\Backend\Components\Dialogs\GiftCard\Type;

use Bookly\Lib as BooklyLib;
use BooklyPro\Lib\Entities;

/**
 * Class Dialog
 * @package BooklyPro\Backend\Components\Dialogs\GiftCard\Type
 */
class Dialog extends BooklyLib\Base\Component
{
    /**
     * Render gift card type dialog.
     */
    public static function render()
    {
        self::enqueueStyles( array(
            'backend' => array( 'css/fontawesome-all.min.css' => array( 'bookly-backend-globals' ), ),
        ) );

        self::enqueueScripts( array(
            'module' => array( 'js/gift-card-type-dialog.js' => array( 'bookly-backend-globals' ) ),
        ) );

        $staff_members = BooklyLib\Entities\Staff::query()
            ->select( 'id, full_name AS title, COALESCE(category_id,0) AS category' )
            ->whereNot( 'visibility', 'archive' )
            ->fetchArray();
        $categories = BooklyLib\Entities\Category::query()->select( 'id, name AS title' )->fetchArray();
        $categories[] = array( 'id' => 0, 'title' => __( 'Uncategorized', 'bookly' ) );

        wp_localize_script( 'bookly-gift-card-type-dialog.js', 'BooklyL10nGiftCardTypeDialog', array(
            'datePicker' => BooklyLib\Utils\DateTime::datePickerOptions(),
            'staff' => array(
                'collection' => $staff_members,
                'categories' => Entities\StaffCategory::query()->select( 'id, name AS title' )->fetchArray(),
            ),
            'services' => array(
                'collection' => BooklyLib\Entities\Service::query()->select( 'id, title, COALESCE(category_id,0) AS category' )->fetchArray(),
                'categories' => $categories,
            ),
            'l10n' => array(
                'title' => __( 'Title', 'bookly' ),
                'no_limit' => __( 'No limit', 'bookly' ),
                'date_limit' => __( 'Date limit (from and to)', 'bookly' ),
                'appointment_limit' => __( 'Limit appointments in cart (min and max)', 'bookly' ),
                'noa_limit' => __( 'Specify minimum and maximum (optional) number of services of the same type required to apply a gift card.', 'bookly' ),
                'amount' => __( 'Amount', 'bookly' ),
                'clear_field' => __( 'Clear field', 'bookly' ),
                'entity' => array(
                    'new' => __( 'New gift card type', 'bookly' ),
                    'edit' => __( 'Edit gift card type', 'bookly' )
                ),
                'services' => array(
                    'label' => __( 'Services', 'bookly' ),
                    'selectAll' => __( 'All services', 'bookly' ),
                    'allSelected' => __( 'All services', 'bookly' ),
                    'nothingSelected' => __( 'No service selected', 'bookly' ),
                ),
                'staff' => array(
                    'label' => __( 'Providers', 'bookly' ),
                    'selectAll' => __( 'All staff', 'bookly' ),
                    'allSelected' => __( 'All staff', 'bookly' ),
                    'nothingSelected' => __( 'No staff selected', 'bookly' ),
                ),
                'save' => __( 'Save', 'bookly' ),
                'cancel' => __( 'Cancel', 'bookly' ),
            ),
        ) );

        print '<div id="bookly-gift-card-type-dialog"></div>';
    }
}