<?php
namespace BooklyPro\Lib\DataHolders\Details;

use Bookly\Lib as BooklyLib;
use Bookly\Lib\DataHolders\Booking\Item;
use Bookly\Lib\DataHolders\Details;
use BooklyPro\Lib\Entities;
use BooklyPro\Lib\CodeGenerator;

class GiftCard extends Details\Base
{
    protected $type = self::TYPE_GIFT_CARD;

    protected $fields = array(
        'id',
        'code',
        'type_id',
        'title',
        'cost',
        'tax',
    );

    /**
     * @param \BooklyPro\Lib\DataHolders\Booking\GiftCard $item
     * @return void
     */
    protected function setItem( Item $item )
    {
        $card_type = Entities\GiftCardType::find( $item->getGiftCardTypeId() );
        $this->price = $card_type->getAmount();
        // ? = $price
        $this->deposit = 0;

        $this->setData( array(
            'type_id' => $card_type->getId(),
            'cost' => $card_type->getAmount(),
            'title' => $card_type->getTitle(),
            'tax' => 0,
        ) );
    }

    public function createGiftCard( BooklyLib\Entities\Payment $payment )
    {
        $type = Entities\GiftCardType::find( $this->getValue( 'type_id' ) );
        if ( $type ) {
            $gift_card = new Entities\GiftCard();
            $gift_card
                ->setGiftCardTypeId( $type->getId() )
                ->setBalance( $type->getAmount() )
                ->setCode( CodeGenerator::generateUniqueCode( '\BooklyPro\Lib\Entities\GiftCard', get_option( 'bookly_cloud_gift_default_code_mask', 'GIFT-****' ) ) )
                ->setPaymentId( $payment->getId() )
                ->setOrderId( $payment->getOrderId() )
                ->save();
            $this->setData( array(
                'id' => $gift_card->getId(),
                'code' => $gift_card->getCode(),
                'cost' => $type->getAmount(),
            ) );

            return $gift_card;
        }
    }
}